/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.network;

import dev.ftb.extendedexchange.network.PacketArcaneTabletRecipeTransfer;
import dev.ftb.extendedexchange.network.PacketClearRecipeCache;
import dev.ftb.extendedexchange.network.PacketGuiButton;
import dev.ftb.extendedexchange.network.PacketJEIGhost;
import dev.ftb.extendedexchange.network.PacketNotifyKnowledgeChange;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "2";
    private static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("extendedexchange", "main_channel")).clientAcceptedVersions("2"::equals).serverAcceptedVersions("2"::equals).networkProtocolVersion(() -> "2").simpleChannel();
    private static int det = 0;

    private static int nextId() {
        return det++;
    }

    public static void init() {
        NetworkHandler.registerMessage(PacketJEIGhost.class, PacketJEIGhost::toBytes, PacketJEIGhost::new, PacketJEIGhost::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketClearRecipeCache.class, PacketClearRecipeCache::toBytes, PacketClearRecipeCache::new, PacketClearRecipeCache::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketGuiButton.class, PacketGuiButton::toBytes, PacketGuiButton::new, PacketGuiButton::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketNotifyKnowledgeChange.class, PacketNotifyKnowledgeChange::toBytes, PacketNotifyKnowledgeChange::new, PacketNotifyKnowledgeChange::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketArcaneTabletRecipeTransfer.class, PacketArcaneTabletRecipeTransfer::toBytes, PacketArcaneTabletRecipeTransfer::new, PacketArcaneTabletRecipeTransfer::handle, NetworkDirection.PLAY_TO_SERVER);
    }

    private static <MSG> void registerMessage(Class<MSG> messageType, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer, NetworkDirection direction) {
        NETWORK.registerMessage(NetworkHandler.nextId(), messageType, encoder, decoder, messageConsumer, Optional.of(direction));
    }

    public static void sendToPlayer(ServerPlayer sp, Object message) {
        NETWORK.send(PacketDistributor.PLAYER.with(() -> sp), message);
    }

    public static void sendToServer(Object message) {
        NETWORK.sendToServer(message);
    }

    public static void sendToAll(Object message) {
        NETWORK.send(PacketDistributor.ALL.noArg(), message);
    }
}

